
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                            Multithread lock                               //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "..\include.h"

///////////////////////////////////////////////////////////////////////////////
// constructor

CLock::CLock()
{
#ifdef _MT
	::InitializeCriticalSection(&m_Lock);
#else // _MT
	m_Lock = false;
#endif // _MT
}

///////////////////////////////////////////////////////////////////////////////
// destructor

CLock::~CLock()
{
#ifdef _MT
	::DeleteCriticalSection(&m_Lock);
#endif // _MT
}

///////////////////////////////////////////////////////////////////////////////
// lock

void CLock::Lock()
{
#ifdef _MT
	::EnterCriticalSection(&m_Lock);
#else // _MT
	if (m_Lock)
	{
		fprintf(stderr, "DEAD LOCK!\n");
		exit(1);
	}
	//while (m_Lock) ::Sleep(5);
	m_Lock = true;
#endif // _MT
}

///////////////////////////////////////////////////////////////////////////////
// try to lock (returns TRUE if successful)

bool CLock::TryLock()
{
#ifdef _MT
	return ::TryEnterCriticalSection(&m_Lock);
#else // _MT
	if (m_Lock) return false;
	m_Lock = true;
	return true;
#endif // _MT
}

///////////////////////////////////////////////////////////////////////////////
// unlock

void CLock::Unlock()
{
#ifdef _MT
	::LeaveCriticalSection(&m_Lock);
#else // _MT
	m_Lock = false;
#endif // _MT
}
